// plugins/validation.ts
// @ts-ignore
import { defineNuxtPlugin } from '#app'

export default defineNuxtPlugin((nuxtApp) => {
    const t = nuxtApp.vueApp.config.globalProperties.$t

    const validate = (field: any, rules: string[], label = '') => {
        const errors: string[] = []

        const ruleCheck = (ruleName: string) => {
            return typeof rules.find((item) => item.includes(ruleName)) !== 'undefined'
        }

        const getRule = (ruleName: string) => {
            return rules.find((item) => item.includes(ruleName))
        }

        if (ruleCheck('required')) {
            if (
                field === '' ||
                field === null ||
                field === undefined ||
                (Array.isArray(field) && field.length === 0)
            ) {
                errors.push(t('validation.required', { label }))
            }
        }

        if (ruleCheck('min')) {
            const min = parseInt(getRule('min')?.split(':')[1] || '0', 10)
            if (field?.length < min) {
                errors.push(t('validation.min', { label, min }))
            }
        }

        if (ruleCheck('max')) {
            const max = parseInt(getRule('max')?.split(':')[1] || '9999', 10)
            if (field?.length > max) {
                errors.push(t('validation.max', { label, max }))
            }
        }

        if (ruleCheck('email')) {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/
            if (!emailRegex.test(field)) {
                errors.push(t('validation.email', { label }))
            }
        }

        if (ruleCheck('numeric')) {
            const numRegex = /^[0-9]+$/
            if (!numRegex.test(field)) {
                errors.push(t('validation.numeric', { label }))
            }
        }

        return errors
    }

    return {
        provide: {
            validation: {
                validate,
            }
        },
    }
})
