import { defineStore } from 'pinia';

export const useFilterStore = defineStore('filter', {
    state: () => ({
        price_min: "",
        price_max: "",
        image: "",
        special: "",
        exchange: "",
        requested: "",
        category: "",
        attributes: [],
        province: "",
        city: "",
        zone: "",
        type: "all",
    }),

    actions: {
        async setFilter(filter) {
            this.filter = filter;
        },
        resetFilter() {
            this.price_min = "";
            this.price_max = "";
            this.image = "";
            this.special = "";
            this.exchange = "";
            this.requested = "";
            this.category = "";
            this.province = "";
            this.type = "all";
            this.attributes = [];
        }
    },

    getters: {
        getFilter: (state) => state
    }
});