// https://nuxt.com/docs/api/configuration/nuxt-config
// @ts-ignore
export default defineNuxtConfig({
    compatibilityDate: '2024-04-03',
    devtools: { enabled: false },
    ssr: false,

    modules: [
        '@pinia/nuxt',
        '@nuxtjs/i18n'
    ],

    i18n: {
        strategy: 'no_prefix',
        defaultLocale: 'fa',
        locales: [
            {
                code: 'fa',
                name: 'فارسی',
                dir: 'rtl',
                file: 'fa.json',
                iso: 'fa-IR'
            },
            {
                code: 'en',
                name: 'English',
                dir: 'ltr',
                file: 'en.json',
                iso: 'en-US'
            },
            {
                code: 'ar',
                name: 'العربية',
                dir: 'rtl',
                file: 'ar.json',
                iso: 'ar-SA'
            }
        ],
        lazy: true,
        langDir: 'locales',
        detectBrowserLanguage: {
            useCookie: true,
            cookieKey: 'locale',
            redirectOn: 'no'
        },
        bundle: {
            optimizeTranslationDirective: false
        },
        vueI18n: './i18n.config.ts'
    },

    app: {
        head: {
            title: 'آرت جو',
            htmlAttrs: {
                lang: 'fa'
            },
            meta: [
                { charset: 'utf-8' },
                { name: 'viewport', content: 'width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no' },
                { name: 'format-detection', content: 'telephone=no' }, // ← اضافه شد
                { httpEquiv: 'Content-Security-Policy', content: "default-src 'self'; script-src 'self'" }, // ← اضافه شد
                { hid: 'description', name: 'description', content: 'وب‌سایت آرت‌جو - خرید و فروش حرفه‌ای کالا و خدمات' },
                { name: 'theme-color', content: '#ff9800' },

                // Open Graph (برای اشتراک‌گذاری در شبکه‌های اجتماعی)
                { hid: 'og:title', property: 'og:title', content: 'آرت جو' },
                { hid: 'og:description', property: 'og:description', content: 'وب‌سایت آرت‌جو - خرید و فروش حرفه‌ای کالا و خدمات' },
                { hid: 'og:image', property: 'og:image', content: '/cover.jpg' },
                { hid: 'og:site_name', property: 'og:site_name', content: 'آرت جو' },
                { hid: 'og:locale', property: 'og:locale', content: 'fa_IR' },
                { hid: 'og:locale:alternate', property: 'og:locale:alternate', content: 'en_US' },
                { hid: 'og:locale:alternate', property: 'og:locale:alternate', content: 'ar_SA' },

                // Apple
                { name: 'apple-mobile-web-app-capable', content: 'yes' },
                { name: 'apple-mobile-web-app-status-bar-style', content: 'black-translucent' }
            ],
            link: [
                { rel: 'icon', type: 'image/x-icon', href: '/favicon/favicon.ico' },
                { rel: 'apple-touch-icon', href: '/favicon/apple-touch-icon.png' },
                { rel: 'manifest', href: '/site.webmanifest' },

                // hreflang برای سئو چندزبانه
                { rel: 'alternate', hreflang: 'fa', href: 'https://example.com/fa' },
                { rel: 'alternate', hreflang: 'en', href: 'https://example.com/en' },
                { rel: 'alternate', hreflang: 'ar', href: 'https://example.com/ar' },
                { rel: 'alternate', hreflang: 'x-default', href: 'https://example.com' }
            ]
        }
    },

    generate: {
        fallback: '404.html',
        routes: []
    },

    render: {
        http2: {
            push: true
        },
        csp: true
    },

    experimental: {
        payloadExtraction: true
    },

    runtimeConfig: {
        public: {
            apiBaseUrl: process.env.BASE_URL || 'https://api.artjoo.com/v1',
            loaderPrimaryColor: process.env.loaderPrimaryColor || '#DDD',
            loaderSecondaryColor: process.env.loaderSecondaryColor || '#FFF'
        }
    },

    css: [
        'bootstrap/dist/css/bootstrap.min.css',
        'swiper/css',
        'swiper/css/free-mode',
        'swiper/css/navigation',
        'swiper/css/pagination',
        'swiper/css/thumbs',
        '@/assets/css/material-icons.min.css',
        '@/assets/css/hafez-icofont.css',
        '@/assets/scss/_variable.scss',
        '@/assets/css/main.css',
        '@neshan-maps-platform/vue3-openlayers/dist/style.css'
    ],

    plugins: [
        '~/plugins/axios.ts',
        { src: '~/plugins/load.ts', mode: 'client' }
    ],

    nitro: {
        cache: {
            redis: {}
        },
        middleware: ['~/server/middleware/redirect.js']
    },

    build: {
        analyze: true
    }
});
