// @ts-ignore
export default defineNuxtPlugin(() => {

    const numberToWords = (input: number) => {
        const ones = ["", "یک", "دو", "سه", "چهار", "پنج", "شش", "هفت", "هشت", "نه", "ده",
            "یازده", "دوازده", "سیزده", "چهارده", "پانزده", "شانزده", "هفده",
            "هجده", "نوزده"];
        const tens = ["", "", "بیست", "سی", "چهل", "پنجاه", "شصت", "هفتاد", "هشتاد", "نود"];
        const hundreds = ["", "صد", "دویست", "سیصد", "چهارصد", "پانصد", "ششصد",
            "هفتصد", "هشتصد", "نهصد"];
        const scales = ["", "هزار", "میلیون", "میلیارد", "تریلیون"];

        if (input === 0) return "صفر";

        let result = "";
        let scaleIndex = 0;

        // تقسیم عدد به گروه‌های سه‌رقمی
        while (input > 0) {
            let currentPart = input % 1000;
            if (currentPart > 0) {
                const partInWords = convertThreeDigits(currentPart);
                if (result) {
                    result = partInWords + (scales[scaleIndex] ? " " + scales[scaleIndex] : "") + " و " + result;
                } else {
                    result = partInWords + (scales[scaleIndex] ? " " + scales[scaleIndex] : "") + result;
                }
            }
            input = Math.floor(input / 1000);
            scaleIndex++;
        }

        return result.trim();
    }

    const convertThreeDigits = (input: number) => {
        const ones = ["", "یک", "دو", "سه", "چهار", "پنج", "شش", "هفت", "هشت", "نه", "ده",
            "یازده", "دوازده", "سیزده", "چهارده", "پانزده", "شانزده", "هفده",
            "هجده", "نوزده"];
        const tens = ["", "", "بیست", "سی", "چهل", "پنجاه", "شصت", "هفتاد", "هشتاد", "نود"];
        const hundreds = ["", "صد", "دویست", "سیصد", "چهارصد", "پانصد", "ششصد",
            "هفتصد", "هشتصد", "نهصد"];

        let word = "";

        // صدگان
        if (Math.floor(input / 100) > 0) {
            word += hundreds[Math.floor(input / 100)] + " ";
            input %= 100;
        }

        // دهگان و یکان (اعداد زیر 20)
        if (input > 0) {
            if (word.length > 0) word += "و ";
            if (input < 20) {
                word += ones[input] + " ";
            } else {
                word += tens[Math.floor(input / 10)] + " ";
                input %= 10;
                if (input > 0) {
                    word += "و " + ones[input] + " ";
                }
            }
        }

        return word.trim();
    }

    const getCurrency = (price: string | number, lang = 'en') => { // eslint-disable-line no-param-reassign

        if (typeof price !== "undefined") {
            price = price.toString().replace(/[\D\s\._\-]+/g, "");
            price = price ? parseInt(price, 10) : 0;

            price = price.toLocaleString("en-US");

            // @ts-ignore
            price = price.toString().replaceAll('.00', '');

            if (lang === 'fa') {
                // @ts-ignore
                price = price.toString().replaceAll('0', '۰');
                // @ts-ignore
                price = price.toString().replaceAll('1', '۱');
                // @ts-ignore
                price = price.toString().replaceAll('2', '۲');
                // @ts-ignore
                price = price.toString().replaceAll('3', '۳');
                // @ts-ignore
                price = price.toString().replaceAll('4', '۴');
                // @ts-ignore
                price = price.toString().replaceAll('5', '۵');
                // @ts-ignore
                price = price.toString().replaceAll('6', '۶');
                // @ts-ignore
                price = price.toString().replaceAll('7', '۷');
                // @ts-ignore
                price = price.toString().replaceAll('8', '۸');
                // @ts-ignore
                price = price.toString().replaceAll('9', '۹');
            }
        }
        return numberEnToPer(price);
    };

    const numberEnToPer = (input: number | string) => {
        input = input.toString();
        const englishDigits = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
        const persianDigits = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];

        return input.split('').map(char => {
            const index = englishDigits.indexOf(char);
            return index === -1 ? char : persianDigits[index];
        }).join('');
    }

    return {
        provide: {
            helper: {
                numberToWords,
                getCurrency,
                numberEnToPer,
            },
        },
    }
})
