import { defineStore } from 'pinia'
import { useCookie } from 'nuxt/app'
import {useFilterStore} from "./filter"; // Use Nuxt's cookie composable

export const useCitiesStore = defineStore('cities', {
    state: () => ({
        cities: [],
    }),

    getters: {
        getCities: (state) => state.cities,
    },

    actions: {
        initCities() {
            const citiesCookie = useCookie('cities',{ maxAge: 60 * 60 * 24 * 365 });

            this.cities = citiesCookie.value || [];

            if (this.cities.length > 0) {
                const filterStore = useFilterStore();
                filterStore.city = this.cities.join(','); // مقداردهی مستقیم
                console.log('city in filterStore:', filterStore.city);
            }
        },


        setCities(cities: any) {
            const citiesCookie = useCookie('cities',{ maxAge: 60 * 60 * 24 * 365 });


            // Set the cities in the cookie with 1 year expiry
            citiesCookie.value = cities;

            this.cities = cities;
        },
    },
});
